/*:ja
 * @plugindesc (v.1.1) '移動ルート'内で使用できるスクリプトを追加します。スクリプト入力欄で右クリックして'ヘルプ'を表示し、使用可能なコマンドを表示できます。
 * @url http://galvs-scripts.com
 * @target MZ
 * @author Galv
 *
 * @help
 * 翻訳:ムノクラ
 * https://fungamemake.com/
 * https://x.com/munokura/
 *
 * 元プラグイン:
 * https://galvs-scripts.com/2020/08/27/mz-move-route-extras/
 *
 *   Galv's Move Route Extras
 * ---------------------------------------------------------------------------
 * 使用可能なスクリプトコマンドを追加し、'移動ルート'に機能を追加します。
 * 使用可能なコマンドは以下のとおりです。
 *
 * ---------------------------------------------------------------------------
 *   移動ルートに追加されるスクリプト
 * ---------------------------------------------------------------------------
 * this.jump_forward(x);
 *          前方へxタイル分ジャンプ
 * this.jump_to(x,y);
 *          マップ上のx,y座標へジャンプ
 * this.jump_to(i);
 *          キャラクターのx,y位置へジャンプ
 *          i = イベントID。プレイヤーの場合は0に
 * this.step_toward(x,y);
 *          マップ上のx,y座標への移動
 * this.step_toward(i);
 *          キャラクタのx,y位置に向かって移動する
 *          i = イベントID。プレイヤーの場合は0に
 * this.step_away(x,y);
 *          マップ上のx,y座標から離れる
 * this.step_away(i);
 *          キャラクタのx,y位置から離れる
 *          i = イベントID。プレイヤーの場合は0に
 * this.turn_toward(x,y);
 *          マップ上のx,y座標の方を向く
 * this.turn_toward(i);
 *          キャラクタのx,y位置の方を向く
 *          i = イベントID。プレイヤーの場合は0に
 * this.turn_away(x,y);
 *          x,yマップの座標から離れる
 * this.turn_away(i);
 *          キャラクターのx,yの位置から離れる
 *          i = イベントID。プレイヤーの場合は0に
 * this.sswitch("n",status);
 *          セルフスイッチ'n'をstatus(true/false)に変更する
 * this.rwait(low,high);
 *          lowとhighの間のランダムな時間をウェイト
 *
 * this.fade(s);
 *          s はフェード速度
 *          正の値はフェードイン、負の値はフェードアウト
 * this.step_rand(id,id,id);
 *          指定されたリージョンIDの上だけをランダムに移動する
 *          複数のIDをカンマで区切って使用できます。
 * this.repeat_begin(n);
 *          この後にあるコマンドをn回繰り返します。
 * this.repeat_end();
 *          繰り返しを折返します。
 *
 * this.doAnimation(id);
 *          id = キャラクターで表示するアニメーションID
 * this.doBalloon(id);
 *          id = キャラクターで表示するフキダシID
 *
 * this.set_frame("name",index,pattern,direction)
 *          画像をフレームに設定する
 *
 * // "name"    - キャラセットファイル名（拡張子なし）
 * // index     - キャラセットのキャラ番号 (1-8)
 * // pattern   - ステッピングフレーム (1-3)
 * // direction - イベントが向いている方向 (2,4,6,8)
 * // キャラクターがフレームに設定されたら、
 *    以下の移動ルートスクリプトを使用してキャラクターを復元するまで、
 *    移動しても変更されません:
 *
 * this.restore_frame()
 *          set_frameで選択されたフレームのロックを解除します
 *
 *
 * ---------------------------------------------------------------------------
 *   使用例
 * ---------------------------------------------------------------------------
 * this.jump_forward(3);
 *          キャラが向いている方向に3タイル分ジャンプ
 * this.jump_to(5);
 *          イベント5の位置にジャンプ
 * this.jump_to(10,16);
 *          x10, y15にジャンプ
 * this.step_toward(3);
 *          イベント3の位置に向けて一歩進む
 * this.step_away(12,8);
 *          x12, y8座標から一歩離れる
 * this.sswitch("A",true);
 *          イベントのセルフスイッチ'A'をONにする
 * this.sswitch("B",false);
 *          イベントのセルフスイッチ'B'をOFFにする
 * this.rwait(60,120);
 *          60～120フレームの間でランダムに待機
 * this.fade(-10);
 *          キャラをフェードアウト
 * this.step_rand(1,4,7);
 *          リージョン1,4,7にのみランダムに移動する
 * this.requestAnimation(2);
 *          キャラクターにアニメーション2を表示
 * ---------------------------------------------------------------------------
 */
